/*
 * Decompiled with CFR 0.152.
 */
package tiled.plugins.json;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.json.XML;
import tiled.core.Map;
import tiled.core.TileSet;
import tiled.io.MapWriter;
import tiled.io.xml.XMLMapWriter;

public class JSONMapWriter
extends XMLMapWriter
implements MapWriter {
    private void writeMapOrTileset(Map map, TileSet tileSet, String string) throws Exception {
        File file = File.createTempFile("tiled_json_", ".tmx");
        if (map != null) {
            super.writeMap(map, file.getAbsolutePath());
        } else if (tileSet != null) {
            super.writeTileset(tileSet, file.getAbsolutePath());
        } else {
            return;
        }
        file = new File(file.getAbsolutePath());
        int n = 100000;
        char[] cArray = new char[n];
        FileReader fileReader = new FileReader(file.getAbsolutePath());
        fileReader.read(cArray);
        fileReader.close();
        String string2 = new String(cArray).trim().replaceFirst("\\<\\?.*\\?\\>", "");
        System.out.println("temp file path=" + file.getAbsolutePath());
        System.out.println("filesize=" + n);
        System.out.println("content=" + string2);
        file.delete();
        String string3 = XML.toJSONObject(string2).toString(2);
        System.err.println("json content=" + string3);
        FileWriter fileWriter = new FileWriter(string);
        fileWriter.write(string3);
        fileWriter.flush();
        fileWriter.close();
    }

    public void writeMap(Map map, String string) throws Exception {
        this.writeMapOrTileset(map, null, string);
    }

    public void writeTileset(TileSet tileSet, String string) throws Exception {
        this.writeMapOrTileset(null, tileSet, string);
    }

    public void writeMap(Map map, OutputStream outputStream) throws Exception {
        super.writeMap(map, outputStream);
    }

    public void writeTileset(TileSet tileSet, OutputStream outputStream) throws Exception {
        super.writeTileset(tileSet, outputStream);
    }

    public String getFilter() throws Exception {
        return "*.js,*.js.gz";
    }

    public String getPluginPackage() {
        return "Tiled JSON writer";
    }

    public String getDescription() {
        return "The Tiled JSON format (TMX converted) writer\n\nNader AKHRES\n for \nTiled Map Editor, (c) 2005\nAdam Turk\nBjorn Lindeijer";
    }

    public String getName() {
        return "Tiled JSON (TMX converted) map writer";
    }

    public boolean accept(File file) {
        try {
            String string = file.getCanonicalPath();
            if (string.endsWith(".js") || string.endsWith(".js.gz")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

